// Main for testing backprop code

#define		LEARNING_RATE		0.45
#define		MAX_TRAIN_CYCLE		200000
#define 	ACCEPTABLE_ERROR   	0.1
#define		INCREMENTAL		0	// or batch

#include "ANN.h"      // the artificial neural net system class
#include <math.h>     // for fabs
#include <String.h>
#include <iostream.h>
#include <fstream.h>

#define MAX_LINE_LENGTH	   256
#define MAX_OUTPUT_NEURONS 100 // this is needed for static declaration during net evaluation

int main()
{
  int incremental = INCREMENTAL;
  int n_neurons_in_input_layer,
    n_neurons_in_output_layer;
  
  // First open the input file containing sample data, and create an output file.
  
  fstream samples, outputFile;
  
  char* pInputFileName  = "samples.txt";
  char* pOutputFileName = "output.txt";
  char	inputBuffer[MAX_LINE_LENGTH];
  char	inputBuffer2[MAX_LINE_LENGTH];
  
  cout << endl << "inputFile  = " << pInputFileName;
  cout << endl << "outputFile = " << pOutputFileName << endl << endl;

  cout << "Acceptable? ";
  cin  >> inputBuffer;
  
  int try_again = true;
  while (try_again)
  {
    try_again = false;
    if ( (inputBuffer[0] == 'n') || (inputBuffer[0] == 'N') )
    {
      cout << "\n" << "inputFile ? ";
      cin  >> inputBuffer;	
      pInputFileName  = inputBuffer;
      
      cout << "outputFile? ";
      cin  >> inputBuffer2;	
      pOutputFileName = inputBuffer2;
    }
    cout << "\n\n";
    
    // try to open the samples input file
    samples.open(pInputFileName, ios::in | ios::nocreate | ios::skipws);
    if ( ! samples.is_open() )
    {                                                
      cout << "Can't open input file " << pInputFileName << "\n\n";
      inputBuffer[0] = 'n';
      try_again = true;
    }
    else
    {		
      // verify that the input file at least specifies the number of neurons in the input and
      // output layers.  This info should be the first two integers in the sample file.
      if (samples.peek() == EOF) try_again = true;
      else samples >> n_neurons_in_input_layer;
      if (samples.peek() == EOF) try_again = true;
      else samples >> n_neurons_in_output_layer;
      if (try_again)
      {
	cout << "Error reading input file\n\n";
	samples.close();
      }
      else
	outputFile.open(pOutputFileName, ios::out);
    }
  }

  cout << "Number of neurons in  input layer: " << n_neurons_in_input_layer << "\n";
  cout << "Number of neurons in output layer: " << n_neurons_in_output_layer << "\n\n";
  
  // create the net
  ANN theNet(n_neurons_in_input_layer, n_neurons_in_output_layer);
  
  // find out how many hidden layers
  int n_hidden_layers;
  cout << "How many hidden layers? ";
  cin >> n_hidden_layers;
  
  // add the hidden layers
  int i;
  for (i=1; i <= n_hidden_layers; i++) 
  {
    int n_neurons_in_this_hidden_layer;
    cout << "How many units (> 0) in hidden layer #" << i << "? ";
    cin >> n_neurons_in_this_hidden_layer;
    
    theNet.AddHiddenLayer( n_neurons_in_this_hidden_layer );
  }
  
  // create a list to store all the sample data and desired outputs.
  CObDLList     allSamples;	
  ACTIVITY_TYPE anActivity;
  
  // read in each set of sample/desiredOutput values.
  while (samples.peek() != EOF) // there is another sample
  {   
    // create an array of double words to hold the new sample
    CObXPlex* sample        = new CObXPlex();
    CObXPlex* desiredOutput = new CObXPlex();
    
    // read in the input for each neuron of this sample		
    cout << "\nsample: ";
    for (i=0; i < n_neurons_in_input_layer; i++)
    {   
      if (samples.peek() == EOF)
      {
	cout << "\nError:  the input file of samples is not balanced (check last sample input).\n\n";
	exit(2);
      }
      samples >> anActivity;
      cout << anActivity << " ";
      sample->add_high(new NeuronActivity(anActivity));
    }
    // read in this sample's desired output for each output neuron
    cout << "desiredOutput: ";
    for (i=0; i < n_neurons_in_output_layer; i++)
    {   
      if (samples.peek() == EOF)
      {
	cout << "\nError:  the input file of samples is not balanced (check last desiredOutput).\n\n";
	exit(2);
      }
      samples >> anActivity;
      cout << anActivity << " ";
      desiredOutput->add_high(new NeuronActivity(anActivity));
    }

    samples.ipfx(); // eat whitespace
    
    // add this sample/desiredOutput pair to the list of all samples
    allSamples.append( sample );
    allSamples.append( desiredOutput );
  }
  samples.close();  // close the input file
  
  // how many samples did we read in?  allSamples is a list which contains two objects
  // for each sample (one is the sample's data, and one is the sample's desiredOutput).
  // So, the count of samples should be the count of objects in allSamples divided by 2.
  int sampleCount = allSamples.length()/2;
  cout << "\n\n" << sampleCount << " samples read.\n\n";
  
  // find out how many samples to train with.
  cout << "How many would you like to use for training (# or #%) ? ";
  cin >> inputBuffer;
  
  // calculate how many training samples from the user's response	
  int n_to_train = sampleCount; // initialize to all in case we get a screwy input
  BString theInput(inputBuffer);
  // int loc = theInput.index('%');
  // Convert to BString, CGP, 6/15/00
  int loc = theInput.FindFirst('%');
  
  // const char *cString;
  
  if (loc == -1)  { // not a percentage
  	// cout << "not a percentage: " << inputBuffer << "\n";
  	sscanf(inputBuffer, "%d", &n_to_train);
    // n_to_train = atoi(inputBuffer);
  }
  else
  {
    // theInput = theInput.before(loc);
    // cString = theInput.String();
    // cout << "theInput before truncation: ";
    // cout << cString;
    // cout << "\n";
    theInput.Truncate(loc);
    // cout << "theInput after truncation: ";
    // cString = theInput.String();
    // cout << cString << "\n";
    double percent;
    sscanf(theInput.String(), "%lf", &percent);
    n_to_train = (int) (percent / 100.0 * sampleCount);
  }
  
  cout << "Output file contains weights\n";
  theNet.OutputWeights(outputFile);
  
  if (n_to_train > sampleCount) n_to_train = sampleCount;
  
  // Until performance is satisfactory, analyze each sample and update the net's weights.
  int performance_is_unsatisfactory = true;
  unsigned long n_training_cycles = 1;
  Pix pos;
  
  while (performance_is_unsatisfactory)
  {
    // test to see if performance is satisfactory	
    performance_is_unsatisfactory = false;
    pos = allSamples.first(); // head
    
    // Iterate over all the samples
    for (int c=1; c <= n_to_train; c++)
    { 
      CObXPlex* theSample = (CObXPlex*)allSamples(pos);
      allSamples.next(pos);

      CObXPlex* theDesiredOutput = (CObXPlex*) allSamples(pos);
      allSamples.next(pos);

      CObXPlex* theResult = theNet.Evaluate(theSample);	
      
      // check for errors
      for ( int j=0; j < n_neurons_in_output_layer; j++ )
      {
	NeuronActivity* desired  = (NeuronActivity*)((*theDesiredOutput)[j]);
	NeuronActivity* observed = (NeuronActivity*)((*theResult)[j]);
	
	double errorSize = fabs( desired->activity - observed->activity );
	
	if (errorSize > ACCEPTABLE_ERROR)
	{
	  performance_is_unsatisfactory = true;
	  cout << " s" << c << ": ";//*****
	  cout << " d= " << desired->activity; //*****
	  cout << " o= " << observed->activity; //*****
	  
	  // delete the rest of theResult
	  j++;
	  while (j < n_neurons_in_output_layer)
	  {
	    delete (*theResult)[j++];
	  }
	}
	
	// we are updating the weights per sample if in incremental mode
	if ((errorSize > 0) && (incremental)) {
	    theNet.Analyze( theSample, theDesiredOutput, (double) LEARNING_RATE );
	    theNet.Train();
	}
	
	delete observed;
      }
      
      theResult->clear();
      delete theResult;
      
      // if we are in batch mode, and we have an error, then exit this loop
      if ((! incremental) && performance_is_unsatisfactory) {
      	break;
      }
    }

    // if we are in batch mode & there is at least one error
    if ((! incremental) && (performance_is_unsatisfactory))
    {
      // compute the weight change for each sample  (do not change the
      // weights until all sample have been analyzed).
      pos = allSamples.first();
      // cout << "Analyzing: ";
      
      for (i = 1; i <= n_to_train; i++)
      {
	CObXPlex* theSample        = (CObXPlex*) allSamples(pos);
	allSamples.next(pos);
	CObXPlex* theDesiredOutput = (CObXPlex*) allSamples(pos);
	allSamples.next(pos);
	
	// cout << i << " ";
	
	theNet.Analyze( theSample, theDesiredOutput, (double) LEARNING_RATE );
      }
      
      // now update the weights
      theNet.Train();
    }

    if (performance_is_unsatisfactory) {
    	cout << "Cycle # " << n_training_cycles++ << "\n";
    }
    
    if (n_training_cycles > MAX_TRAIN_CYCLE) break;
  }
  
  // cout << "Weights after training...\n";
  theNet.OutputWeights(outputFile);
  
  //int z;
  //cout << "Press any character and enter to continue...\n";
  //cin >> z;
  
  cout << "\nEvaluating:\n";
  int correct = 0;
  while (pos != NULL)
  {
    CObXPlex* theSample        = (CObXPlex*) allSamples(pos);
    allSamples.next(pos);
    CObXPlex* theDesiredOutput = (CObXPlex*) allSamples(pos);
    allSamples.next(pos);
    
    CObXPlex* theResult		   = theNet.Evaluate(theSample);
    
    cout << i++ << ":	desired   (	";
    
    ACTIVITY_TYPE	Observed[MAX_OUTPUT_NEURONS], 
      Desired[MAX_OUTPUT_NEURONS];  
    
    int DesiredMostActive = 0;  // initially assume the first neuron should be most active
    int j;
    for (j=0; j < n_neurons_in_output_layer; j++)
    {
      NeuronActivity* theActivity = (NeuronActivity*)(*theDesiredOutput)[j];
      Desired[j] = theActivity->activity;
      cout << Desired[j] << "		";
      
      if (Desired[j] > Desired[DesiredMostActive])
      {
	DesiredMostActive = j;
      }
      
    }		
    
    cout << ")\n	evaluated (	";
    int ObservedMostActive = 0;
    for (j=0; j < n_neurons_in_output_layer; j++)
    {
      NeuronActivity* theActivity = (NeuronActivity*)((*theResult)[j]);
      Observed[j] = theActivity->activity;
      cout << Observed[j] << "  	";
      
      delete theActivity;
      
      if (Observed[j] > Observed[ObservedMostActive])
      {
	ObservedMostActive = j;
      }
    }
    theResult->clear();
    delete theResult;
    
    cout << ")\n";
    
    // this part is particular to a net that looks for one output neuron to be
    // more active than all the others
    if (DesiredMostActive == ObservedMostActive)
    {
      correct++;
      cout << "	CORRECT!\n";
    }
    else cout << "	WRONG!\n";		
  }	
  cout << "\n\nTotal correct = " << correct << " out of " << sampleCount - n_to_train << " test cases";
  cout << " = " << (float)correct / (float)(sampleCount - n_to_train) * 100 << "% correct\n";
  cout << "Number of training samples = " << n_to_train<< "\n";
  cout << "Training took " << n_training_cycles << " cycles.\n";
  
  outputFile.close();
  exit(1);
}
